package gov.va.genisis2;

import java.io.ByteArrayOutputStream;

import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;

public class JenaConnection {

	protected String endpoint;
	protected String query;
	protected long connectionTimeout;
	protected long readTimeout;
	protected boolean successfullQuery;

	public JenaConnection(String endpoint) {
		this.endpoint = endpoint;
		this.connectionTimeout = 5000; 
		this.readTimeout = 5000;
		successfullQuery = false;
	}

	public JenaConnection(String endpoint, String query) {
		this.endpoint = endpoint;
		this.query = query;
	}

	public String executeQuery(String query) {
		this.query = query;
		QueryExecution qe = null;
		try {
			qe = QueryExecutionFactory.sparqlService(endpoint, query);
//			qe.setTimeout(readTimeout, connectionTimeout);
			ResultSet results = qe.execSelect();
			
			//check to see if there results model is null or not..if so then there 
			//may be no need to show the curl request
			if( results.getResourceModel() != null )
				successfullQuery = true;
			else
				successfullQuery = false;

			ByteArrayOutputStream b = new ByteArrayOutputStream();
			ResultSetFormatter.outputAsJSON(b, results);
			return b.toString();
		} catch (Exception e) {
			return e.toString();
		} finally {
			if( qe != null)
				qe.close();
		}
	}

	public String testConnection() {
		QueryExecution qe = null;
		try {
			qe = QueryExecutionFactory.sparqlService(endpoint, "ASK {}");
//			qe.setTimeout(readTimeout, connectionTimeout);
			if (qe.execAsk())
				return " is UP!!";
			else
				return " is Down!!";
		} catch (Exception e) {
			return " is Down!!";
		} finally {
			if( qe != null )
				qe.close();
		}
	}
	
	/**
	 * Returns true if the query ran successfully
	 * @return
	 */
	public boolean getQuerySuccess() {
		return successfullQuery;
	}
	
	/**
	 * Returns the format of a successul query of N/A if the query is malformed
	 * @return
	 */
	public String getCurlFormat() {
		if( getQuerySuccess() ) {
			return "curl "+endpoint+" --data-urlencode"+" 'query="+query.replaceAll("\n", "").
					replaceAll("\t", "")+"'";
		}
		else
			return "Query was malformed...see above";
	}
}
